
DROP FUNCTION public.ufd_est_prod_tbl_desc_leve_pague(integer, integer, integer, integer, integer, integer);

-- FUNCTION: public.ufd_est_prod_tbl_desc_leve_pague(integer, integer, integer, integer, integer)

-- DROP FUNCTION public.ufd_est_prod_tbl_desc_leve_pague(integer, integer, integer, integer, integer, integer);


CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_leve_pague(
	integer,
	integer,
	integer,
	integer,
	integer,
	integer)

--RETURNS SETOF public.rs_tab_desc_qtde AS
--$body$

    RETURNS SETOF rs_tab_desc_qtde 
    LANGUAGE 'plpgsql'

    COST 100
    VOLATILE 
    ROWS 1000
AS $BODY$

-- versã£o 09/09/2022


 --<<inicio do corpo da funcao
-- function: select * from ufd_est_prod_tbl_desc_leve_pague(1, 18, 13492, 3,1,0)
--declara as variaveis usadas na funcao
declare
---------------------------------------------------------
----declara as variaveis que estao no cabecalho da funcao
---------------------------------------------------------
int_cd_emp              alias for $1;
int_cd_filial           alias for $2; 
int_cd_prod             alias for $3;
int_qtde             	alias for $4;
int_cd_forma_pgto       alias for $5;
int_usa_desconto_propz_ident ALIAS FOR $6;
---------------------------------------------------------
---fim
---------------------------------------------------------
var_trabalhacomdescontoformadepagamento 	integer;


returnrec rs_tab_desc_qtde; --recebera os dados de retorno da funcao
begin --inicio dos blocos da funcao
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela temporaria de retorno
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table temp_rs_tab_desc_leve_page
		(	
			cd_tbl_desc_qtde 	integer,
			tp_desc 			integer,
			qtde_pag	 		integer,
			tp_nivel			integer,
			agregacao			integer,
			dt_ini              timestamp without time zone
		);
		exception when others then
		truncate table temp_rs_tab_desc_leve_page; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela que recebera as tbls vigentes
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_tab_qtde_ativa
		(	
			cd_emp 				integer,    
			cd_tbl_desc_qtde	integer,    
			tp_desc 			integer
		);
		exception when others then
		truncate table rs_tab_qtde_ativa; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------
	--declarando tabela de arvore mercadologica do produto
	-------------------------------------------------------------------------------------------------------------------------------
	begin
		create temporary table rs_est_prod_arv_merc
		(
			cd_emp					integer,
			cd_prod					integer,
			cd_arv_merc_categ		integer,
			cd_arv_merc_linha		integer,
			cd_mc					integer,
			cd_arv_merc_familia		integer,								
			cd_fabric				integer
		);--fim rs_est_prod_arv_merc
		exception when others then
		truncate table rs_est_prod_arv_merc; -- trunca a tabela se ela ja existir na corrente sessao.
	end;
	-------------------------------------------------------------------------------------------------------------------------------	
	---------------------------------------------------fim da criacao das tbls temporarias-----------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	-------------------------------------------------------------------------------------------------------------------------------
	--buscando arvore merc. do produto
	-------------------------------------------------------------------------------------------------------------------------------	
	insert into rs_est_prod_arv_merc		
		select 
			arv.cd_emp					,
			arv.cd_prod					,
			arv.cd_arv_merc_categ		,
			arv.cd_arv_merc_linha		,
			arv.cd_mc					,
			arv.cd_arv_merc_familia		,												
			p.cd_fabric 
		from 	est_prod_est_arv_mercadologica arv inner join est_prod p on
				arv.cd_emp		= p.cd_emp
				and arv.cd_prod = p.cd_prod
		where   	arv.cd_emp = int_cd_emp
			and 	arv.cd_prod = int_cd_prod;
			
			
	var_trabalhacomdescontoformadepagamento = coalesce((select coalesce(valor,'0')::integer from prc_filial_config where cd_chave = 'usa_desconto_pgto' and cd_filial = int_cd_filial), 0);			
			
	if exists (select 1 from rs_est_prod_arv_merc) then
		-------------------------------------------------------------------    
		--tabelas de desc. quantidade    
		-------------------------------------------------------------------    
		insert into rs_tab_qtde_ativa    
				select  a.cd_emp,    
						a.cd_tbl_desc_qtde,
						a.cd_tp_desconto    
				from est_prod_tbl_desc_qtde a inner join
				     est_prod_tbl_desc_qtde_prc_filial fil on    
					    a.cd_emp = fil.cd_emp and    
					    a.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde 
				where  int_cd_emp = a.cd_emp and        
					   int_cd_filial = fil.cd_filial and
					   current_date between date(a.dt_ini) and date(a.dt_fim) and
					   a.sts_tbl_desc = 1 and    
					   a.cd_tp_desconto = 24 and               
					   a.qtde_leve <= int_qtde
					   AND (
						 ((int_usa_desconto_propz_ident = 1) AND (a.flag_tp_desconto_propz in(0,1))) OR 
						 ((int_usa_desconto_propz_ident = 0) AND (a.flag_tp_desconto_propz =0))
					   );					   
					   
					   
		if var_trabalhacomdescontoformadepagamento = 1 then  
			 
	
			delete from rs_tab_qtde_ativa a 
			 where not exists (select b.cd_emp
			      				 from est_prod_tbl_desc_qtde_forma_pgto b  
				    			where b.cd_emp             = a.cd_emp
				    			  and b.cd_tbl_desc_qtde   = a.cd_tbl_desc_qtde   
				    			  and b.cd_frm_pgto      = int_cd_forma_pgto  
				    			    ) ;
	
		end if ; 					   
					   
					   
					   
		if exists (select 1 from rs_tab_qtde_ativa) then
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 1 - produtos    
			-------------------------------------------------------------------------------------------------------------------------------    
			 insert into temp_rs_tab_desc_leve_page     
				select    
						a.cd_tbl_desc_qtde as cd_tbl_desc_qtde,    
						a.cd_tp_desconto as tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg, --calcula a quantidade de protudos que serao pagos
						1 as tp_nivel,
						agregacao,
						a.dt_ini
				from est_prod_tbl_desc_qtde a    
						inner join est_prod_tbl_desc_qtde_est_prod b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						inner join est_prod_tbl_desc_qtde_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						inner join rs_tab_qtde_ativa atv on    
							b.cd_emp = atv.cd_emp and    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde     
						inner join rs_est_prod_arv_merc arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_prod = arv.cd_prod           
				where     
					fil.cd_filial = int_cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 2 - familias    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_leve_page     
				select   
						a.cd_tbl_desc_qtde as cd_tbl_desc_qtde,    
						a.cd_tp_desconto as tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg,        
						2 as tp_nivel,
						agregacao,
						a.dt_ini    
				from est_prod_tbl_desc_qtde a    
						inner join est_prod_tbl_desc_qtde_est_arv_merc_familia b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						inner join est_prod_tbl_desc_qtde_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						inner join rs_est_prod_arv_merc arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_arv_merc_familia = arv.cd_arv_merc_familia    
						inner join rs_tab_qtde_ativa atv on    
							a.cd_emp = atv.cd_emp and    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
				where     
					fil.cd_filial = int_cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------        
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 3 - marcas    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_leve_page     
				select
						a.cd_tbl_desc_qtde as cd_tbl_desc_qtde,    
						a.cd_tp_desconto as tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg,          
						3 as tp_nivel,
						agregacao,
						a.dt_ini    
				from est_prod_tbl_desc_qtde a    
						inner join est_prod_tbl_desc_qtde_est_mc b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						inner join est_prod_tbl_desc_qtde_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						inner join rs_est_prod_arv_merc arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_mc = arv.cd_mc    
						inner join rs_tab_qtde_ativa atv on    
							a.cd_emp = atv.cd_emp and    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
				where     
					fil.cd_filial = int_cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 4 - fabricantes    
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_leve_page     
				select   
						a.cd_tbl_desc_qtde as cd_tbl_desc_qtde,    
						a.cd_tp_desconto as tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg,         
						4 as tp_nivel,
						agregacao,
						a.dt_ini     
				from est_prod_tbl_desc_qtde a    
						inner join est_prod_tbl_desc_qtde_est_prod_fabric b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						inner join est_prod_tbl_desc_qtde_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						inner join rs_est_prod_arv_merc arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_fabric = arv.cd_fabric     
						inner join rs_tab_qtde_ativa atv on    
							b.cd_emp = atv.cd_emp and    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
				where     
					fil.cd_filial = int_cd_filial;
			------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 5 - categorias         
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_leve_page     
				select   
						a.cd_tbl_desc_qtde as cd_tbl_desc_qtde,    
						a.cd_tp_desconto as tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg,           
						5 as tp_nivel,
						agregacao,
						a.dt_ini  
				from est_prod_tbl_desc_qtde a    
						inner join est_prod_tbl_desc_qtde_est_arv_merc_categoria b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						inner join est_prod_tbl_desc_qtde_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						inner join rs_est_prod_arv_merc arv on    
							b.cd_emp = arv.cd_emp and    
							b.cd_arv_merc_categ = arv.cd_arv_merc_categ    
						inner join rs_tab_qtde_ativa atv on    
							a.cd_emp = atv.cd_emp and    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
				where     
					fil.cd_filial = int_cd_filial;
			-------------------------------------------------------------------------------------------------------------------------------    
			--consultando as tbls de desconto para verificar se ha algum desconto no nivel 6 - linhas
			-------------------------------------------------------------------------------------------------------------------------------    
			insert into temp_rs_tab_desc_leve_page     
				select   
						a.cd_tbl_desc_qtde as cd_tbl_desc_qtde,    
						a.cd_tp_desconto as tp_desc,    
						(abs(int_qtde / a.qtde_leve) * a.qtde_pague) + (int_qtde - (abs(int_qtde / a.qtde_leve) * a.qtde_leve)) as qtde_pg,        
						6 as tp_nivel,
						agregacao,
						a.dt_ini 
				from est_prod_tbl_desc_qtde a    
						inner join est_prod_tbl_desc_qtde_est_arv_merc_linha b on    
							a.cd_emp = b.cd_emp and    
							a.cd_tbl_desc_qtde = b.cd_tbl_desc_qtde    
						inner join est_prod_tbl_desc_qtde_prc_filial fil on    
							b.cd_emp = fil.cd_emp and    
							b.cd_tbl_desc_qtde = fil.cd_tbl_desc_qtde    
						inner join rs_est_prod_arv_merc arv on    
							b.cd_emp = arv.cd_emp and       
							b.cd_arv_merc_linha = arv.cd_arv_merc_linha    
						inner join rs_tab_qtde_ativa atv on    
							a.cd_emp = atv.cd_emp and    
							b.cd_tbl_desc_qtde = atv.cd_tbl_desc_qtde        
				where     
					fil.cd_filial = int_cd_filial;
		end if;
	end if;
	-------------------------------------------------------------------------------------------------------------------------------
	-- retornando desconto limite (resultado da funcao)
	-------------------------------------------------------------------------------------------------------------------------------
	for returnrec in 
		select cd_tbl_desc_qtde, tp_desc, qtde_pag, 1, round((1-(cast(qtde_pag as numeric)/int_qtde))*100,2), round((1-(cast(qtde_pag as numeric)/int_qtde))*100,2), tp_nivel, agregacao 
		  from temp_rs_tab_desc_leve_page 
		 order by tp_nivel asc, qtde_pag desc, dt_ini desc limit 1
	loop
		return next returnrec;
	end loop;
	
END; --FIM DOS BLOCOS DA FUNCAO

$BODY$;

ALTER FUNCTION public.ufd_est_prod_tbl_desc_leve_pague(integer, integer, integer, integer, integer, integer)
    OWNER TO postgres;

/*
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;

CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_leve_pague(integer, integer, integer, integer, integer)
RETURNS SETOF public.rs_tab_desc_qtde AS
$body$
DECLARE RET rs_tab_desc_qtde;
BEGIN
  RET = ufd_est_prod_tbl_desc_leve_pague($1, $2, $3, $4, $5, 0);
  RETURN NEXT RET;
END
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
PARALLEL UNSAFE
COST 100 ROWS 1000;
*/